extends Camera

export var SideSwitcheSpeed : float = 2
#nodes
onready var globalGame = get_tree().get_current_scene() #Global Game Node

onready var tweenY : Tween = $TweenY
onready var tweenZ : Tween = $TweenZ
onready var level_finished : Tween = $level_finished
onready var side_move : Tween = $side_move
onready var boost : Tween = $boost
onready var player = get_parent().get_node("player_ball") 
onready var level = get_parent()
var left_right_shift = 0


func _ready():
	globalGame.connect("on_step",self,"on_step_emittedY")
	globalGame.connect("on_step",self,"on_step_emittedZ")
	
	globalGame.connect("on_boost",self,"on_boost_emitted")
	globalGame.connect("on_long_stair",self,"on_long_stair_emitted")
	level.connect("level_completed",self,"on_level_completed")
	restore_checkpoint()


func on_step_emittedY():
	var change_by : int  = 1
	var current_view : Vector3 = translation
	
	var from = current_view.y
	var to = from + change_by
	
	tweenY.interpolate_property(self,
	"translation:y",
	from,
	to,
	0.5,Tween.TRANS_CIRC,
	Tween.EASE_OUT)
	
	tweenY.start()
	
func on_step_emittedZ():
	var change_by : int  = 1
	var current_view : Vector3 = translation
	
	var from = current_view.z
	var to = from - change_by
	
	tweenZ.interpolate_property(self,
	"translation:z",
	from,
	to,
	0.5,Tween.TRANS_CIRC,
	Tween.EASE_OUT)
	
	tweenZ.start()

func on_level_completed() -> void:
	return
	if side_move.is_active():
		yield(side_move,"tween_all_completed")
	level_finished.interpolate_method(self,
	"boost_view",
	Vector2(translation.x,rotation_degrees.y), #default best value 0.0
	Vector2(translation.x-3,0), #default best value 0.4
	0.4,
	Tween.TRANS_QUINT,
	Tween.EASE_OUT) #default best value 1/0.9
	level_finished.start()

## Rotate and focus on the player , used by the tween 
## to get smooth transition and rotation //// depricated
func boost_view(ease_by : Vector2) -> void :
	translation.x = ease_by.x
	rotation_degrees.y = ease_by.y

func on_boost_emitted(safe_stair : Vector3) -> void:
	yield(get_tree().create_timer(0.3),"timeout")
	var target = abs(safe_stair.z) - abs(player.translation.z) - 1
	if tweenY.is_active() or tweenZ.is_active() :
		yield(tweenY,"tween_all_completed")
		yield(tweenZ,"tween_all_completed")
	boost.interpolate_property(self,
	"translation",
	translation,
	translation + Vector3(0,target,-target),
	1,
	Tween.TRANS_CUBIC,
	Tween.EASE_OUT)
	boost.start()

func on_long_stair_emitted(direction : int):
	if side_move.is_active():
		yield(side_move,"tween_all_completed")
	var current_view = translation
	var from = current_view.x
	var to = from + (10 * direction)
	
	if direction == -1 : # left
		left_right_shift += 10
	else: # 1 right 
		left_right_shift -= 10
	
	side_move.interpolate_property(self,
	"translation:x",
	from,
	to,
	SideSwitcheSpeed,Tween.TRANS_LINEAR, #defualt circ
	Tween.EASE_IN_OUT) #default out
	
	side_move.start()


func restore_checkpoint() -> void:
	var game_data = B4DFramework.get_game_data()
	if game_data.keys().find("checkpoint") == -1:
		return
		
	if game_data.checkpoint != Vector3.ZERO:
		set_translation(game_data.checkpoint + Vector3(0,8.5,8.5))
